unit Form.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls, SDK.DeliveryPharmacy.V2;

type
  TfrmMain = class(TForm)
    MemoResponse: TMemo;
    Panel1: TPanel;
    lbResponseStatus: TLabel;
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Bevel1: TBevel;
    edtIDPedido: TEdit;
    Button3: TButton;
    Button4: TButton;
    edtMotivoCancelamentoPedido: TEdit;
    GroupBox2: TGroupBox;
    Button5: TButton;
    Bevel2: TBevel;
    edtIDProduto: TEdit;
    Button6: TButton;
    Button7: TButton;
    GroupBox3: TGroupBox;
    Button8: TButton;
    Bevel3: TBevel;
    edtIDPromocao: TEdit;
    Button9: TButton;
    Button10: TButton;
    edtIDProdutoPromocao: TEdit;
    Button11: TButton;
    Button12: TButton;
    GroupBox4: TGroupBox;
    Button13: TButton;
    Bevel4: TBevel;
    Bevel5: TBevel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
  private
    FSDK: TDeliveryPharmacy;

    procedure UpdateResponse;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses
  System.JSON;

{$R *.dfm}

procedure TfrmMain.Button10Click(Sender: TObject);
begin
  if trim(edtIDPromocao.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID da Promoo');
    ActiveControl := edtIDPromocao;
    exit;
  end;

  FSDK.DeletePromocao(edtIDPromocao.Text);
  UpdateResponse;
end;

procedure TfrmMain.Button11Click(Sender: TObject);
var
  LJSON: TJSONObject;
begin
  if trim(edtIDPromocao.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID da Promoo');
    ActiveControl := edtIDPromocao;
    exit;
  end;

  if trim(edtIDProdutoPromocao.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID do Produto');
    ActiveControl := edtIDProdutoPromocao;
    exit;
  end;

  LJSON := TJSONObject.Create
                      .AddPair('porcentagem', 5.5) // Porcentagem do desconto a ser aplicado sobre o preo do produto. (Se Tipo da promoo for "Desconto Porcentagem")
                      .AddPair('valor', 0);        // Valor do produto com desconto aplicado. (Se Tipo da promoo for "Desconto Valor")

  FSDK.PostPromocaoProduto(edtIDPromocao.Text, edtIDProdutoPromocao.Text, LJSON);
  UpdateResponse;
end;

procedure TfrmMain.Button12Click(Sender: TObject);
begin
  if trim(edtIDPromocao.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID da Promoo');
    ActiveControl := edtIDPromocao;
    exit;
  end;

  if trim(edtIDProdutoPromocao.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID do Produto');
    ActiveControl := edtIDProdutoPromocao;
    exit;
  end;

  FSDK.DeletePromocaoProduto(edtIDPromocao.Text, edtIDProdutoPromocao.Text);
  UpdateResponse;
end;

procedure TfrmMain.Button13Click(Sender: TObject);
var
  LJSON: TJSONObject;
begin
  LJSON := TJSONObject.Create
                      .AddPair('codigo', '1')         // Cdigo da forma de pagamento no software da loja
                      .AddPair('nome', 'Pix')         // Nome da forma de pagamento no software da loja
                      .AddPair('pedir_troco', False); // Se forma de pagamento permitir troco informar "true" (Ex.: Dinheiro) e se no permitir informar "false" (Ex.: Carto Crdito)

  FSDK.PostFormaPagto(LJSON);
  UpdateResponse;
end;

procedure TfrmMain.Button1Click(Sender: TObject);
begin
  if trim(edtIDPedido.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID do Pedido');
    ActiveControl := edtIDPedido;
    exit;
  end;

  FSDK.GetPedido(edtIDPedido.Text);
  UpdateResponse;
end;

procedure TfrmMain.Button2Click(Sender: TObject);
begin
  FSDK.GetPedidos;
  UpdateResponse;
end;

procedure TfrmMain.Button3Click(Sender: TObject);
begin
  if trim(edtIDPedido.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID do Pedido');
    ActiveControl := edtIDPedido;
    exit;
  end;

  FSDK.PutPedidoSincronizado(edtIDPedido.Text);
  UpdateResponse;
end;

procedure TfrmMain.Button4Click(Sender: TObject);
begin
  if trim(edtIDPedido.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID do Pedido');
    ActiveControl := edtIDPedido;
    exit;
  end;

  if trim(edtMotivoCancelamentoPedido.Text) = EmptyStr then
  begin
    ShowMessage('Informe o motivo do cancelamento');
    ActiveControl := edtMotivoCancelamentoPedido;
    exit;
  end;

  FSDK.PutPedidoCancelado(edtIDPedido.Text, edtMotivoCancelamentoPedido.Text);
  UpdateResponse;
end;

procedure TfrmMain.Button5Click(Sender: TObject);
var
  LJSON: TJSONObject;
  LJSONCodigosBarras: TJSONArray;
begin
  LJSONCodigosBarras := TJSONArray.Create
                                  .Add('7896094921344')
                                  .Add('7896026303002');

  LJSON := TJSONObject.Create
                      .AddPair('codigo', '1')                             // Cdigo do produto no software da loja
                      .AddPair('nome', 'BUSCOFEM 400MG C 10 CAPS')        // Nome do produto no software da loja
                      .AddPair('valor', 26.14)                            // Valor/Preo de venda do produto na loja
                      .AddPair('indisponivel', false)                     // Disponibilidade do item na loja (Ex.: Item sem estoque e/ou indisponvel informar "true")
                      .AddPair('inativo', false)                          // Item inativo ou deletado na loja (Ex.: Se item estiver inativo ou for deletado na loja deve ser informado "true")
                      .AddPair('codigo_barras', '7896094921344')          // Cdigo de barras do produto no software da loja
                      .AddPair('lista_codigo_barras', LJSONCodigosBarras) // Matriz com todos os cdigos de barras do produto no software da loja, inclusive o cdigo informado no campo "CodigoBarras"

                      // Os prximos campos so opcionais, envie se quiser, mas quanto mais informaes sobre o produto, melhor.

                      .AddPair('descricao', 'Breve descrio do produto') // Descrio do produto (Detalhes, caractersticas e informaes do produto)
                      .AddPair('quantidade_caixa', 0)                     // Quantidade de itens na caixa/pack. (Para venda de itens em caixas/pack fechados)
                      .AddPair('valor_promocao', 24.5)                    // Valor/Preo promocional do produto na loja
                      .AddPair('estoque', 15)                             // Quantidade em estoque do produto na loja
                      .AddPair('principio_ativo', 'Ibuprofeno');          // Princpio ativo do produto

  FSDK.PostProduto(LJSON);
  UpdateResponse;
end;

procedure TfrmMain.Button6Click(Sender: TObject);
var
  LJSON: TJSONObject;
  LJSONCodigosBarras: TJSONArray;
begin
  if trim(edtIDProduto.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID do Produto');
    ActiveControl := edtIDProduto;
    exit;
  end;

  LJSONCodigosBarras := TJSONArray.Create
                                  .Add('7896094921344')
                                  .Add('7896026303002');

  LJSON := TJSONObject.Create
                      .AddPair('codigo', '1')                             // Cdigo do produto no software da loja
                      .AddPair('nome', 'BUSCOFEM 400MG C 10 CAPS')        // Nome do produto no software da loja
                      .AddPair('valor', 30.9)                             // Valor/Preo de venda do produto na loja
                      .AddPair('indisponivel', false)                     // Disponibilidade do item na loja (Ex.: Item sem estoque e/ou indisponvel informar "true")
                      .AddPair('inativo', false)                          // Item inativo ou deletado na loja (Ex.: Se item estiver inativo ou for deletado na loja deve ser informado "true")
                      .AddPair('codigo_barras', '7896094921344')          // Cdigo de barras do produto no software da loja
                      .AddPair('lista_codigo_barras', LJSONCodigosBarras) // Matriz com todos os cdigos de barras do produto no software da loja, inclusive o cdigo informado no campo "CodigoBarras"

                      // Os prximos campos so opcionais, envie se quiser, mas quanto mais informaes sobre o produto, melhor.

                      .AddPair('descricao', 'Breve descrio do produto') // Descrio do produto (Detalhes, caractersticas e informaes do produto)
                      .AddPair('quantidade_caixa', 0)                     // Quantidade de itens na caixa/pack. (Para venda de itens em caixas/pack fechados)
                      .AddPair('valor_promocao', 29.75)                   // Valor/Preo promocional do produto na loja
                      .AddPair('estoque', 10)                             // Quantidade em estoque do produto na loja
                      .AddPair('principio_ativo', 'Ibuprofeno');          // Princpio ativo do produto

  FSDK.PutProduto(edtIDProduto.Text, LJSON);
  UpdateResponse;
end;

procedure TfrmMain.Button7Click(Sender: TObject);
var
  LJSON: TJSONObject;
begin
  if trim(edtIDProduto.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID do Produto');
    ActiveControl := edtIDProduto;
    exit;
  end;

  LJSON := TJSONObject.Create
                      .AddPair('valor', 32.9)            // Valor/Preo de venda do produto na loja
                      .AddPair('indisponivel', false)    // Disponibilidade do item na loja (Ex.: Item sem estoque e/ou indisponvel informar "true")
                      .AddPair('inativo', true)          // Item inativo ou deletado na loja (Ex.: Se item estiver inativo ou for deletado na loja deve ser informado "true")

                      // Os prximos campos so opcionais, envie se quiser, mas quanto mais informaes sobre o produto, melhor.

                      .AddPair('valor_promocao', 30.75); // Valor/Preo promocional do produto na loja

  FSDK.PutProdutoValor(edtIDProduto.Text, LJSON);
  UpdateResponse;
end;

procedure TfrmMain.Button8Click(Sender: TObject);
var
  LJSON: TJSONObject;
begin
  LJSON := TJSONObject.Create
                      .AddPair('ativa', true)              // Promoo ativa informar "true" e se inativa informar "false"
                      .AddPair('inicio', '2024-07-01')     // Data inicial da promoo no formato yyyy-mm-dd
                      .AddPair('termino', '2024-07-31')    // Data final da promoo no formato yyyy-mm-dd
                      .AddPair('nome', 'Nome da promoo') // Nome da promoo
                      .AddPair('codigo', '1')              // Cdigo da promoo no software da loja
                      .AddPair('tipo', 0);                 // Informar 0 (Desconto Porcentagem) ou 1 (Desconto Valor)

  FSDK.PostPromocao(LJSON);
  UpdateResponse;
end;

procedure TfrmMain.Button9Click(Sender: TObject);
var
  LJSON: TJSONObject;
begin
  if trim(edtIDPromocao.Text) = EmptyStr then
  begin
    ShowMessage('Informe o ID da Promoo');
    ActiveControl := edtIDPromocao;
    exit;
  end;

  LJSON := TJSONObject.Create
                      .AddPair('ativa', true)                 // Promoo ativa informar "true" e se inativa informar "false"
                      .AddPair('inicio', '2024-07-01')        // Data inicial da promoo no formato yyyy-mm-dd
                      .AddPair('termino', '2024-07-31')       // Data final da promoo no formato yyyy-mm-dd
                      .AddPair('nome', 'Promoo Julho 2024') // Nome da promoo
                      .AddPair('codigo', '1')                 // Cdigo da promoo no software da loja
                      .AddPair('tipo', 0);                    // Informar 0 (Desconto Porcentagem) ou 1 (Desconto Valor)

  FSDK.PutPromocao(edtIDPromocao.Text, LJSON);
  UpdateResponse;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  lbResponseStatus.Caption := EmptyStr;

  //Coloque os dados de acesso aqui
  //Executar uma nica vez no sistema antes de instanciar o objeto TDeliveryPharmacy pela primeira vez
  //Pode ser na inicializao do sistema
  //O ID do ERP ser fixo para todos os seus clientes
  //O token e o ID da empresa sero diferentes para cada cliente
  TDeliveryPharmacy.Configure('Informe o token', 'Informe o ID da empresa', 'Informe o ID do ERP');

  FSDK := TDeliveryPharmacy.Create;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  FSDK.Free;
end;

procedure TfrmMain.UpdateResponse;
begin
  if FSDK.Response.isOK then
    lbResponseStatus.Font.Color := clGreen
  else
    lbResponseStatus.Font.Color := clRed;
  lbResponseStatus.Caption := FSDK.Response.CodeStatus.ToString + ' - ' + FSDK.Response.StatusText;

  MemoResponse.Lines.Clear;
  if Assigned(FSDK.Response.JSON) then
  begin
    MemoResponse.Lines.Add(FSDK.Response.JSON.Format);
    MemoResponse.Perform(EM_LINESCROLL, 0, -MemoResponse.Lines.Count);
  end;
end;

end.
